/*
 * Decompiled with CFR 0.152.
 */
package swingpuzzlegui;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import swingpuzzlegui.DNF;
import swingpuzzlegui.HintGenerator;
import swingpuzzlegui.PuzzleGenerator;
import swingpuzzlegui.PuzzleLoader;
import swingpuzzlegui.PuzzleNew;
import swingpuzzlegui.PuzzlePanel;
import swingpuzzlegui.PuzzleSaver;

public class SwingPuzzleGUI {
    public static final Pattern PATTERN = Pattern.compile("^\\d+$");

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingPuzzleGUI.createAndShowGUI();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void createAndShowGUI() throws IOException {
        File theoryHTML;
        JMenuItem theoryDocumentation;
        JMenu helpMenu;
        JMenuBar menuBar;
        JFrame f;
        PuzzlePanel puzzle;
        block15: {
            File helpHTML;
            Path tempDirWithPrefix;
            JMenuItem helpDocumentation;
            block13: {
                DNF.var_count = 6;
                DNF.term_count = 3;
                DNF.term_size = 2;
                DNF dnf = new DNF();
                puzzle = new PuzzlePanel(dnf);
                f = new JFrame("Grid Logic Puzzle");
                f.setDefaultCloseOperation(3);
                f.add(puzzle);
                String root_path = System.getProperty("user.dir");
                JFrame s = new JFrame("Generator");
                JPanel p = new JPanel();
                GridLayout g = new GridLayout(0, 2);
                p.setLayout(g);
                p.add(new JLabel("Variable count"));
                JTextField var_count_box = new JTextField(5);
                var_count_box.setText("" + DNF.var_count);
                p.add(var_count_box);
                p.add(new JLabel("Term count"));
                JTextField term_count_box = new JTextField(5);
                term_count_box.setText("" + DNF.term_count);
                p.add(term_count_box);
                p.add(new JLabel("Term size"));
                JTextField term_size_box = new JTextField(5);
                term_size_box.setText("" + DNF.term_size);
                p.add(term_size_box);
                p.add(new JLabel("Flipped cells"));
                JTextField flipped_cells_box = new JTextField(5);
                flipped_cells_box.setText("" + puzzle.flipped_cells);
                p.add(flipped_cells_box);
                p.add(new JLabel("Blank cells"));
                JTextField blank_cells_box = new JTextField(5);
                blank_cells_box.setText("" + puzzle.blank_cells);
                p.add(blank_cells_box);
                JPanel b = new JPanel();
                JButton generate = new JButton("Generate!");
                b.add(generate);
                generate.addActionListener(new PuzzleGenerator(var_count_box, term_count_box, term_size_box, flipped_cells_box, blank_cells_box, puzzle, f));
                Border raised = BorderFactory.createRaisedBevelBorder();
                Border lowered = BorderFactory.createLoweredBevelBorder();
                CompoundBorder compound = BorderFactory.createCompoundBorder(raised, lowered);
                p.setBorder(compound);
                s.add((Component)p, "North");
                s.add((Component)b, "South");
                s.pack();
                s.setVisible(false);
                s.setResizable(false);
                JFileChooser fc = new JFileChooser(root_path);
                FileNameExtensionFilter dnfFilter = new FileNameExtensionFilter("DNF Grids", "dnf");
                fc.setFileFilter(dnfFilter);
                menuBar = new JMenuBar();
                JMenu fileMenu = new JMenu("Puzzle");
                fileMenu.setMnemonic(80);
                JMenuItem newMenuItem = new JMenuItem("New", 78);
                newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 8));
                newMenuItem.addActionListener(new PuzzleNew(puzzle, f));
                fileMenu.add(newMenuItem);
                JMenuItem openMenuItem = new JMenuItem("Open", 79);
                openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
                openMenuItem.addActionListener(new PuzzleLoader(puzzle, f, fc));
                JMenuItem saveMenuItem = new JMenuItem("Save", 83);
                saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
                saveMenuItem.addActionListener(new PuzzleSaver(puzzle, f, fc));
                JMenuItem paramsMenuItem = new JMenuItem("Generator", 71);
                paramsMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 8));
                paramsMenuItem.addActionListener(e -> {
                    s.setLocation(f.getX() + f.getWidth() + 10, f.getY());
                    s.setVisible(true);
                });
                fileMenu.add(paramsMenuItem);
                JMenuItem quitMenuItem = new JMenuItem("Quit", 81);
                quitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
                quitMenuItem.addActionListener(e -> System.exit(0));
                fileMenu.add(quitMenuItem);
                menuBar.add(fileMenu);
                menuBar.add(Box.createHorizontalGlue());
                helpMenu = new JMenu("Help");
                helpMenu.setMnemonic(72);
                helpDocumentation = new JMenuItem("Usage", 85);
                tempDirWithPrefix = Files.createTempDirectory(String.valueOf(SwingPuzzleGUI.class.getCanonicalName()) + "-helpdocs", new FileAttribute[0]);
                tempDirWithPrefix.toFile().deleteOnExit();
                helpHTML = new File(tempDirWithPrefix + "/minimal_help.html");
                helpHTML.deleteOnExit();
                BufferedWriter bwHelpHTML = null;
                File helpCSS = new File(tempDirWithPrefix + "/minimal_help.css");
                BufferedWriter bwHelpCSS = null;
                try {
                    try {
                        bwHelpHTML = new BufferedWriter(new FileWriter(helpHTML));
                        InputStream inHTML = SwingPuzzleGUI.class.getResourceAsStream("/docs/minimal_help.html");
                        BufferedReader br = new BufferedReader(new InputStreamReader(inHTML));
                        while (br.ready()) {
                            String line = br.readLine();
                            bwHelpHTML.write(String.valueOf(line) + "\n");
                        }
                        bwHelpCSS = new BufferedWriter(new FileWriter(helpCSS));
                        InputStream inCSS = SwingPuzzleGUI.class.getResourceAsStream("/docs/minimal_help.css");
                        BufferedReader br2 = new BufferedReader(new InputStreamReader(inCSS));
                        while (br2.ready()) {
                            String line = br2.readLine();
                            bwHelpCSS.write(String.valueOf(line) + "\n");
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        bwHelpHTML.close();
                        bwHelpCSS.close();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    bwHelpHTML.close();
                    bwHelpCSS.close();
                    throw throwable;
                }
                bwHelpHTML.close();
                bwHelpCSS.close();
            }
            helpDocumentation.addActionListener(e -> {
                try {
                    Desktop.getDesktop().browse(helpHTML.toURI());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            helpMenu.add(helpDocumentation);
            theoryDocumentation = new JMenuItem("Theory", 84);
            theoryHTML = new File(tempDirWithPrefix + "/minimal_theory.html");
            theoryHTML.deleteOnExit();
            BufferedWriter bwTheoryHTML = null;
            File theoryCSS = new File(tempDirWithPrefix + "/minimal_theory.css");
            BufferedWriter bwTheoryCSS = null;
            try {
                try {
                    bwTheoryHTML = new BufferedWriter(new FileWriter(theoryHTML));
                    InputStream inHTML = SwingPuzzleGUI.class.getResourceAsStream("/docs/minimal_theory.html");
                    BufferedReader br = new BufferedReader(new InputStreamReader(inHTML));
                    while (br.ready()) {
                        String line = br.readLine();
                        bwTheoryHTML.write(String.valueOf(line) + "\n");
                    }
                    bwTheoryCSS = new BufferedWriter(new FileWriter(theoryCSS));
                    InputStream inCSS = SwingPuzzleGUI.class.getResourceAsStream("/docs/minimal_theory.css");
                    BufferedReader br3 = new BufferedReader(new InputStreamReader(inCSS));
                    while (br3.ready()) {
                        String line = br3.readLine();
                        bwTheoryCSS.write(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    bwTheoryHTML.close();
                    bwTheoryCSS.close();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                bwTheoryHTML.close();
                bwTheoryCSS.close();
                throw throwable;
            }
            bwTheoryHTML.close();
            bwTheoryCSS.close();
        }
        theoryDocumentation.addActionListener(e -> {
            try {
                Desktop.getDesktop().browse(theoryHTML.toURI());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        helpMenu.add(theoryDocumentation);
        JMenuItem hintMenuItem = new JMenuItem("Hint", 72);
        hintMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        hintMenuItem.addActionListener(new HintGenerator(puzzle));
        helpMenu.add(hintMenuItem);
        menuBar.add(helpMenu);
        f.setJMenuBar(menuBar);
        f.pack();
        f.setVisible(true);
        f.setResizable(false);
    }
}

