/*
 * Decompiled with CFR 0.152.
 */
package swingpuzzlegui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JPanel;
import swingpuzzlegui.DNF;
import swingpuzzlegui.Grid;
import swingpuzzlegui.Tuple;

class PuzzlePanel
extends JPanel {
    Color false_color = new Color(0, 0, 0);
    Color true_color = new Color(255, 255, 255);
    Color unknown_color = new Color(0, 0, 255);
    Color mismatched_color = new Color(0, 255, 255);
    Color guessed_color = new Color(192, 192, 64);
    Color invalid_color = new Color(255, 0, 0);
    Color solved_color = new Color(0, 255, 0);
    public Grid puzzle_grid;
    public Grid working_grid;
    public Grid orig;
    int cell_side;
    int max_cell_side = 20;
    int max_board_side = 800;
    int width;
    int height;
    Dimension size;
    int flipped_cells = 2;
    int blank_cells = 2;

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    public void init(DNF dnf) {
        this.orig = new Grid(dnf);
        this.puzzle_grid = new Grid(this.orig);
        this.puzzle_grid.random_flip(this.flipped_cells);
        this.puzzle_grid.random_unknown(this.blank_cells);
        this.working_grid = new Grid(this.puzzle_grid);
        if (this.working_grid.equals(this.orig)) {
            this.working_grid.matched = true;
        }
        this.cell_side = this.max_board_side / Math.max(this.working_grid.width, this.working_grid.height);
        this.cell_side = Math.min(this.cell_side, this.max_cell_side);
        this.width = this.working_grid.width * this.cell_side;
        this.height = this.working_grid.height * this.cell_side;
        this.size = new Dimension(this.width, this.height);
    }

    public PuzzlePanel(DNF dnf) {
        this.init(dnf);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!PuzzlePanel.this.working_grid.matched) {
                    int x = e.getX() / PuzzlePanel.this.cell_side;
                    int y = e.getY() / PuzzlePanel.this.cell_side;
                    PuzzlePanel.this.working_grid.click_flip(x, y);
                    if (PuzzlePanel.this.working_grid.equals(PuzzlePanel.this.orig)) {
                        PuzzlePanel.this.working_grid.matched = true;
                    }
                    PuzzlePanel.this.repaint();
                }
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        int y;
        int x;
        Tuple<Integer, Integer> coord;
        super.paintComponent(g);
        for (Map.Entry<Tuple<Integer, Integer>, Integer> entry : this.working_grid.cells.entrySet()) {
            int cell_state = entry.getValue();
            coord = entry.getKey();
            switch (cell_state) {
                case 0: {
                    g.setColor(this.false_color);
                    break;
                }
                case 1: {
                    g.setColor(this.true_color);
                    break;
                }
                case 2: {
                    g.setColor(this.unknown_color);
                }
            }
            x = (Integer)coord.x * this.cell_side;
            y = (Integer)coord.y * this.cell_side;
            g.fillRect(x, y, this.cell_side, this.cell_side);
        }
        Color border_color = this.working_grid.matched ? this.solved_color : this.invalid_color;
        for (Map.Entry<Tuple<Integer, Integer>, Integer> entry : this.working_grid.cells.entrySet()) {
            coord = entry.getKey();
            x = (Integer)coord.x * this.cell_side;
            y = (Integer)coord.y * this.cell_side;
            g.setColor(border_color);
            g.drawRect(x, y, this.cell_side, this.cell_side);
        }
        for (Map.Entry<Tuple<Integer, Integer>, Integer> entry : this.working_grid.cells.entrySet()) {
            int working_cell_state;
            coord = entry.getKey();
            x = (Integer)coord.x * this.cell_side;
            y = (Integer)coord.y * this.cell_side;
            int puzzle_cell_state = this.puzzle_grid.cells.get(coord);
            if (puzzle_cell_state == (working_cell_state = entry.getValue().intValue())) continue;
            if (puzzle_cell_state == 2) {
                g.setColor(this.guessed_color);
            } else {
                g.setColor(this.mismatched_color);
            }
            g.drawRect(x - 1, y - 1, this.cell_side, this.cell_side);
            g.drawRect(x, y, this.cell_side, this.cell_side);
            g.drawRect(x + 1, y + 1, this.cell_side, this.cell_side);
        }
    }
}

